/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core;

import com.aptana.core.util.ArrayUtil;
import com.aptana.debug.core.IProcessOutputFilter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

public class FilterProxyInputStream
extends InputStream {
    private static final char CR = '\n';
    private static final int BACKSPACE = 8;
    private IProcessOutputFilter processOutputFilter;
    private ByteArrayInputStream lineBuffer;
    private final BufferedReader reader;
    private Charset charset;

    public FilterProxyInputStream(InputStream in, String encoding, IProcessOutputFilter processOutputFilter) {
        this.processOutputFilter = processOutputFilter;
        this.charset = Charset.defaultCharset();
        try {
            this.charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        this.reader = new BufferedReader(new InputStreamReader(in, this.charset));
    }

    public void setProcessOutputFilter(IProcessOutputFilter processOutputFilter) {
        this.processOutputFilter = processOutputFilter;
    }

    public int read() throws IOException {
        this.fillBuffer();
        int ch = this.lineBuffer.read();
        while (ch == 8) {
            ch = this.lineBuffer.read();
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.fillBuffer();
        int c = this.lineBuffer.read();
        while (c == 8) {
            c = this.lineBuffer.read();
        }
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        while (i < len) {
            c = this.lineBuffer.read();
            while (c == 8) {
                c = this.lineBuffer.read();
            }
            if (c == -1) break;
            b[off + i] = (byte)c;
            ++i;
        }
        return i;
    }

    private void fillBuffer() throws IOException {
        if (this.lineBuffer != null && this.lineBuffer.available() > 0) {
            return;
        }
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            if (this.processOutputFilter != null) {
                line = this.processOutputFilter.filter(line);
            }
            if (line == null) continue;
        }
        this.lineBuffer = new ByteArrayInputStream(line != null ? (String.valueOf(line) + '\n').getBytes(this.charset.name()) : ArrayUtil.NO_BYTES);
    }
}

